
/*
   Copyright (c) 2007-2010, GlassDoor. All rights reserved.

   This software is an unpublished work subject to a confidentiality agreement
   and protected by copyright and trade secret law. Unauthorized copying,
   redistribution or other use of this work is prohibited. All copies must
   retain this copyright notice. Any use or exploitation of this work without
   authorization could subject the perpetrator to criminal and civil liability.

   The information in this software is subject to change without notice
   and should not be construed as a commitment by Glassdoor.com.

   The above copyright notice does not indicate actual or intended publication 
   of this source code.

   $Rev:: 31095                                          $: (current file revision)
   $Date:: 2010-11-30 15:10:24 -0800 (Tue, 30 Nov 2010)  $: (date of last file modification)
   $Author:: coyote                                      $: (person who last modified this file)
*/

if (typeof GD === 'undefined') {
	/**
	 * The GLASSDOOR global namespace object.
	 */
	var GD = {};
}

if (typeof GD.richEditor === 'undefined') {
	/**
	 * The GLASSDOOR 'File Uploads' namespace object.
	 */
	GD.richEditor = {};
}

GD.richEditor.init = function(field, id, className, height, maxPlainTextLength, hasFocus, onChange) {
	field = GD.jquery(field);

//	var		toolbar = [
//			   		  	['Source','-','Save','NewPage','Preview','-','Templates'],
//			   			['Cut','Copy','Paste','PasteText','PasteFromWord','-','Print', 'SpellChecker', 'Scayt'],
//			   		    ['Undo','Redo','-','Find','Replace','-','SelectAll','RemoveFormat'],
//			   		    ['Form', 'Checkbox', 'Radio', 'TextField', 'Textarea', 'Select', 'Button', 'ImageButton', 'HiddenField'],
//			   		    '/',
//			   		    ['Bold','Italic','Underline','Strike','-','Subscript','Superscript'],
//			   		    ['NumberedList','BulletedList','-','Outdent','Indent','Blockquote','CreateDiv'],
//			   		    ['JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock'],
//			   		    ['Link','Unlink','Anchor'],
//			   		    ['Image','Flash','Table','HorizontalRule','Smiley','SpecialChar','PageBreak'],
//			   		    '/',
//			   		    ['Styles','Format','Font','FontSize'],
//			   		    ['TextColor','BGColor'],
//			   		    ['Maximize', 'ShowBlocks','-','About']
//			   		 ];

	var		tb = [
			   		  	['Source','-','Undo','Redo','-'],
			   			['PasteFromWord'],
			   		    ['Bold','Italic','Underline','RemoveFormat'],
			   		    ['NumberedList','BulletedList'],
			   		    ['Link','Unlink'],
			   		    ['SpecialChar']
			   		 ];
	var		ks = [
					    [ CKEDITOR.ALT + 121 /*F10*/, 'toolbarFocus' ],
					    [ CKEDITOR.ALT + 122 /*F11*/, 'elementsPathFocus' ],

					    [ CKEDITOR.SHIFT + 121 /*F10*/, 'contextMenu' ],

					    [ CKEDITOR.CTRL + 90 /*Z*/, 'undo' ],
					    [ CKEDITOR.CTRL + 89 /*Y*/, 'redo' ],
					    [ CKEDITOR.CTRL + CKEDITOR.SHIFT + 90 /*Z*/, 'redo' ],

					    [ CKEDITOR.CTRL + 76 /*L*/, 'link' ],

					    [ CKEDITOR.CTRL + 66 /*B*/, 'bold' ],
					    [ CKEDITOR.CTRL + 73 /*I*/, 'italic' ],
					    [ CKEDITOR.CTRL + 85 /*U*/, 'underline' ],

					    [ CKEDITOR.CTRL + CKEDITOR.SHIFT + 86 /*V*/, 'pastetext' ],
					    
					    [ CKEDITOR.ALT + 109 /*-*/, 'toolbarCollapse' ]
					];
	
	if (!height) {
		height = 200;
		}

	var		options = {
						bodyId:					id,
						bodyClass:				className,
						skin:					'gd',
						height:					height,
						toolbar:				tb,
						keystrokes:				ks,
						startupFocus:			hasFocus,
						autoUpdateElement:		true,
						enableMore:				true,
						shiftEnterMode:			CKEDITOR.ENTER_BR,
						toolbarCanCollapse:		false,
						resize_dir:				'vertical',
						extraPlugins: 			'charCount,fadeOnBlur,autogrow',
						autoGrow_minHeight:		200,
						autoGrow_maxHeight:		500,
						charCountRefresh:		500,
						charCountLimit:			maxPlainTextLength,
						countPlainText:			true,
						charCountFormat:		'<span class="cke_charcount_count">%count%</span> of ' +
												'<span class="cke_charcount_limit">%limit%</span> chars'
					  };

	if (!jQuery.isFunction(onChange)) {
		onChange = null;
	}

	field.ckeditor(function() {
								var		editor = this;
								
								GD.richEditor.onEditorReady(editor, onChange)
							}, options);
}

GD.richEditor.onEditorReady = function(editor, onChange) {
	CKEDITOR.on('currentInstance', GD.richEditor.onEditorFocusChange);

	if (jQuery.isFunction(onChange)) {
		editor.on('key', function(event) {
								onChange();
							});
	}
}


GD.richEditor.charCount = function(editor) {
	var		editorElement = $(editor.container.$);
	var		countElement = $('.cke_count', editorElement);
    var		textContents = editor.getData();
    var		message = textContents.plainTextLength(true) + ' chars';

    countElement.html( message );
}

GD.richEditor.onEditorFocusChange = function(editor) {
	return true;
}
